<?php

use App\Http\Controllers\Web\ArticleController;
use App\Http\Controllers\Web\ContactController;
use App\Http\Controllers\Web\HomeController;
use App\Http\Controllers\Web\ProductController;
use App\Http\Controllers\Web\ProfileController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

// ini route untuk halaman beranda
Route::get('/', [HomeController::class, 'index'])->name('home.index');

// route articles
Route::get('/articles', [ArticleController::class, 'index'])->name('articles.index');
Route::get('/articles/all', [ArticleController::class, 'all'])->name('articles.all');
Route::get('/articles/{slug}', [ArticleController::class, 'detail'])->name('articles.detail');

// route contact
Route::get('/contacts', [ContactController::class, 'index'])->name('contacts.index');

// route profile
Route::get('/profile', [ProfileController::class, 'index'])->name('profile.index');

// route product
Route::get('/products', [ProductController::class, 'index'])->name('products.index');
Route::get('/products/{id}', [ProductController::class, 'detail'])->name('products.detail');

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('dashboard', function () {
        return Inertia::render('dashboard');
    })->name('dashboard');
});

require __DIR__ . '/settings.php';
