export interface Product {
    id: number;
    main_image: string;
    name: string;
    price: number;
}

export interface PaginationLink {
    active: boolean;
    label: string;
    page: number | null;
    url: string | null;
}

export interface ProductPagination {
    current_page: number;
    data: Product[];
    first_page_url: string;
    from: number;
    last_page: number;
    last_page_url: string;
    links: PaginationLink[];
    next_page_url: string | null;
    path: string;
    per_page: number;
    prev_page_url: string | null;
    to: number;
    total: number;
}

export interface Tumbler {
    id: number;
    main_image: string;
    name: string;
}

interface ProductImages {
    id: number;
    caption: string;
    image_url: string;
}

export interface DetailProduct {
    id: number;
    description: string;
    images: ProductImages[];
    main_image: string;
    name: string;
    price: number;
}
