import { PaginationLink } from './products';

export interface Article {
    id: number;
    title: string;
    slug: string;
    image_url: string;
    created_at: string;
}

export interface DetailArticle {
    id: number;
    title: string;
    slug: string;
    description: string;
    image_url: string;
    created_at: string;
}

export interface ArticlePagination {
    current_page: number;
    data: DetailArticle[];
    first_page_url: string;
    from: number;
    last_page: number;
    last_page_url: string;
    links: PaginationLink[];
    next_page_url: string | null;
    path: string;
    per_page: number;
    prev_page_url: string | null;
    to: number;
    total: number;
}
