import aisyah from '@/assets/aisyah.png';
import akhmad from '@/assets/akhmad.png';
import ayu from '@/assets/ayu.png';
import davi from '@/assets/davi.png';
import dkaprofile from '@/assets/dka-profile.png';
import hasrul from '@/assets/hasrul.png';
import img2 from '@/assets/img2.png';
import instagram from '@/assets/instagram.png';
import irgi from '@/assets/irgi.png';
import profileimg1 from '@/assets/profile-img1.png';
import profileimg2 from '@/assets/profile-img2.png';
import profileimg3 from '@/assets/profile-img3.png';
import profileimg4 from '@/assets/profile-img4.png';
import profileimg5 from '@/assets/profile-img5.png';
import profileimg6 from '@/assets/profile-img6.png';
import tiktok from '@/assets/tiktok.png';
import youtube from '@/assets/youtube.png';
import Footer from '@/components/footer';
import Navbar from '@/components/navbar';
import AOS from 'aos';
import 'aos/dist/aos.css';
import { useEffect } from 'react';

export default function Profile() {
    const visions = [
        'Menjadi agensi kreatif terdepan yang menghadirkan solusi inovatif di dunia event dan branding',
    ];

    const missions = [
        'Menghadirkan konsep event yang kreatif, relevan dan berkesan',
        'Memberikan pelayanan profesional dengan standar tinggi',
        'Mengembangkan produk merch yang mendukung identitas brand klien',
        'Membangun kolaborasi jangka panjang dengan mitra dan klien',
    ];

    const crews = [
        { image_url: ayu, name: 'Ayu Purnami' },
        { image_url: davi, name: 'Davi Irvan' },
        { image_url: aisyah, name: 'Aisyah Supri' },
        { image_url: hasrul, name: 'Hasrul Wijaya' },
        { image_url: akhmad, name: 'Akhmad' },
        { image_url: irgi, name: 'Irgi' },
    ];

    const reviews = [
        {
            name: 'PT. Masmindo',
            description:
                'Kami sangat puas dengan penyelenggaraan kegiatan 17 Agustus-an ini. Semua berjalan lancar dan berkesan bagi seluruh peserta. Terima kasih Digital Kreatif Agensi.',
        },
        {
            name: 'BPS Luwu',
            description:
                'Terima kasih DKA atas pengalaman yang  berharga sehingga menciptakan kebersamaan dan keakraban pegawai kami. Jaya selalu Digital Kreatif Agensi.',
        },
        {
            name: 'BPS Palopo',
            description:
                'Digital Kreatif Agensi selalu mengerti apa yang diinginkan oleh client serta selalu memberikan yang terbaik demi kenyamanan dan kepuasan client.',
        },
        {
            name: 'BPS Luwu Utara',
            description:
                'Kami sangat puas dengan Digital Kreatif Agensi karena anggota timnya ramah-ramah dan memberikan ide-ide yang kreatif dan sangat inovatif.',
        },
    ];

    const profile_images = [
        profileimg1,
        profileimg2,
        profileimg3,
        profileimg4,
        profileimg5,
        profileimg6,
    ];

    let delay = 0;

    useEffect(() => {
        AOS.init({ duration: 900, once: true });
    }, []);

    return (
        <>
            <div className="flex min-h-screen flex-col">
                <Navbar />
                <main className="flex-1">
                    <section className="mb-5 flex flex-row items-center justify-between gap-0 rounded-2xl bg-[#06A3C7] md:mb-10 md:gap-x-20 md:rounded-4xl">
                        <div
                            data-aos="fade-right"
                            className="ml-5 flex flex-col gap-2 py-4 md:ml-15 md:gap-6 md:py-2"
                        >
                            <div className="text-lg/5 font-bold md:text-7xl">
                                <h1 className="text-white">Digital Kreatif</h1>
                                <h1 className="text-[#96F78E]">Agensi</h1>
                            </div>
                            <p className="text-[8px] font-medium text-white md:text-lg">
                                Digital Kreatif Agensi adalah perusahaan yang
                                bergerak di bidang Event Organizer, Party
                                Planner, dan Merchandising. Kami berkomitmen
                                menghadirkan pengalaman tak terlupakan melalui
                                konsep kreatif, pelayanan profesional, dan
                                menghasilkan produk berkualitas tinggi
                            </p>
                            <div className="mt-2 flex flex-row gap-2 md:mt-2 md:gap-4">
                                <a href="https://www.tiktok.com/@digitalkreatifagensi1?_t=ZS-90v3PlUeZ8B&_r=1">
                                    <img src={tiktok} className="w-5 md:w-9" />
                                </a>
                                <a href="https://www.instagram.com/digitalkreatifagensi?igsh=anJnMTF4cWZ2enE4">
                                    <img
                                        src={instagram}
                                        className="w-5 md:w-9"
                                    />
                                </a>
                                <a href="https://youtube.com/@digitalkreatifagensi?si=VGJLnkmTAypv46il">
                                    <img src={youtube} className="w-5 md:w-9" />
                                </a>
                            </div>
                        </div>
                        <div
                            data-aos="fade-left"
                            className="mr-5 py-5 md:mr-15"
                        >
                            <img src={dkaprofile} className="w-225 md:w-400" />
                        </div>
                    </section>
                    <section className="mx-5 grid gap-5 md:mx-15 md:grid-cols-3 md:gap-10">
                        <div
                            data-aos="fade-right"
                            className="order-2 w-55 place-self-center md:order-1 md:col-span-1 md:h-100 md:w-auto"
                        >
                            <img src={img2} className="h-full w-full" />
                        </div>
                        <div
                            data-aos="fade-left"
                            className="order-1 md:order-2 md:col-span-2"
                        >
                            <h3 className="mb-1 text-lg font-bold text-[#06A3C7] md:text-3xl">
                                VISI
                            </h3>
                            <div className="mb-3 md:mb-5">
                                {visions.map((vision) => (
                                    <p className="mb-1 text-justify text-[11px] font-medium md:text-base">
                                        {vision}
                                    </p>
                                ))}
                            </div>
                            <h3 className="mb-1 text-lg font-bold text-[#06A3C7] md:text-3xl">
                                MISI
                            </h3>
                            <div>
                                {missions.map((mission) => (
                                    <p className="mb-1 rounded-lg border border-2 border-solid border-[#06A3C7] px-2 py-1 text-justify text-[11px] font-medium md:rounded-2xl md:px-4 md:text-base">
                                        {mission}
                                    </p>
                                ))}
                            </div>
                        </div>
                    </section>
                    <section className="relative mb-7 rounded-2xl bg-[#56C1D9] md:mb-10 md:rounded-4xl">
                        <div className="static mx-5 md:mx-15">
                            <p className="absolute -top-4 left-1/2 -translate-x-1/2 rounded-full bg-[#06A3C7] px-5 py-1 text-base font-bold text-white md:text-2xl">
                                Tim Kami
                            </p>
                            <div
                                data-aos="zoom-in"
                                className="grid grid-cols-2 gap-x-8 gap-y-3 pt-10 pb-5 md:mx-40 md:grid-cols-3 md:gap-x-30 md:gap-y-10 md:pt-15"
                            >
                                {crews.map((crew) => (
                                    <div>
                                        <img
                                            src={crew.image_url}
                                            className="h-30 w-full rounded-2xl object-cover md:h-50"
                                        />
                                        <p className="pt-1 text-center text-sm font-semibold text-white md:pt-2 md:text-xl">
                                            {crew.name}
                                        </p>
                                    </div>
                                ))}
                            </div>
                        </div>
                    </section>
                    <section className="mx-5 mb-7 md:mx-25 md:mb-10">
                        <p
                            data-aos="zoom-in"
                            className="pb-3 text-center text-xl font-bold text-[#06A3C7] md:pb-5 md:text-3xl"
                        >
                            Apa yang mereka katakan tentang kami?
                        </p>
                        <div className="grid-cols grid gap-3 md:grid-cols-2 md:gap-10">
                            {reviews.map((review, index) => {
                                if (index % 2 === 0) {
                                    delay += 300;
                                    return (
                                        <div
                                            data-aos="fade-right"
                                            data-aos-delay={delay}
                                            className="rounded-l-2xl rounded-tr-2xl border border-3 border-solid border-[#06A3C7] px-3 py-1 hover:scale-105 hover:shadow-xl/30 hover:shadow-[#06A3C7] md:rounded-l-3xl md:rounded-tr-3xl md:px-5 md:py-2"
                                        >
                                            <p className="text-base font-semibold text-[#06A3C7] md:text-2xl">
                                                {review.name}
                                            </p>
                                            <p className="text-[10px] font-medium md:text-base">
                                                {review.description}
                                            </p>
                                        </div>
                                    );
                                } else {
                                    delay += 300;
                                    return (
                                        <div
                                            data-aos="fade-left"
                                            data-aos-delay={delay}
                                            className="rounded-tl-2xl rounded-r-2xl border border-3 border-solid border-[#06A3C7] px-3 py-1 hover:scale-105 hover:shadow-xl/30 hover:shadow-[#06A3C7] md:rounded-tl-3xl md:rounded-r-3xl md:px-5 md:py-2"
                                        >
                                            <p className="text-base font-semibold text-[#06A3C7] md:text-2xl">
                                                {review.name}
                                            </p>
                                            <p className="text-[10px] font-medium md:text-base">
                                                {review.description}
                                            </p>
                                        </div>
                                    );
                                }
                            })}
                        </div>
                    </section>
                    <section className="overflow-x-hidden">
                        <div className="relative" data-aos="zoom-in">
                            <div className="animate-scroll-left mb-1 flex w-full gap-1 md:mb-2 md:gap-2">
                                {[...profile_images, ...profile_images].map(
                                    (img) => (
                                        <img
                                            src={img}
                                            className="h-25 w-full object-contain md:h-40"
                                        />
                                    ),
                                )}
                            </div>
                            <div className="animate-scroll-right mb-1 flex w-full gap-1 md:mb-2 md:gap-2">
                                {[...profile_images, ...profile_images].map(
                                    (img) => (
                                        <img
                                            src={img}
                                            className="h-25 w-full object-contain md:h-40"
                                        />
                                    ),
                                )}
                            </div>
                        </div>
                    </section>
                </main>
                <Footer />
            </div>
        </>
    );
}
