import whatsapp from '@/assets/whatsapp.png';
import Footer from '@/components/footer';
import Navbar from '@/components/navbar';
import Partnerships from '@/components/partnerships';
import ProductCard from '@/components/product-card';
import { Partnership } from '@/types/partnerships';
import {
    DetailProduct as DetailProductInterface,
    Product,
} from '@/types/products';
import AOS from 'aos';
import 'aos/dist/aos.css';
import { ChevronLeft } from 'lucide-react';
import { useEffect, useRef, useState } from 'react';

interface DetailProductProps {
    product: DetailProductInterface;
    relatedProducts: Product[];
    partnerships: Partnership[];
}

export default function DetailProduct({
    product,
    relatedProducts,
    partnerships,
}: DetailProductProps) {
    const scrollRef = useRef<HTMLDivElement>(null);

    const [selectedImage, setSelectedImage] = useState(product.main_image);

    useEffect(() => {
        AOS.init({ duration: 900, once: true });
    }, []);

    return (
        <>
            <div className="flex min-h-screen flex-col">
                <Navbar />
                <main className="flex-1">
                    <section className="mx-5 mt-2 mb-5 md:mx-15 md:mt-5 md:mb-10">
                        <a
                            className="inline-flex items-center gap-1 text-[#06A3C7] hover:text-[#696969] dark:hover:text-[#D3D3D3]"
                            href="/products"
                        >
                            <ChevronLeft className="w-4 md:w-5" />
                            <p className="text-xs font-medium md:text-base">
                                Kembali
                            </p>
                        </a>
                        <div className="mt-1 flex flex-col items-start gap-2 md:mt-5 md:flex-row md:gap-5">
                            <div
                                className="flex w-full flex-col gap-2 md:w-125"
                                data-aos="fade-right"
                            >
                                <div className="relative flex h-35 justify-center overflow-hidden rounded-lg md:h-60">
                                    <img
                                        src={selectedImage}
                                        className="h-full rounded-2xl object-cover"
                                    />
                                </div>
                                <div className="flex items-center">
                                    <div
                                        ref={scrollRef}
                                        className="custom-scrollbar flex gap-2 overflow-x-auto scroll-smooth whitespace-nowrap"
                                    >
                                        {product.images.map((img) => (
                                            <div
                                                className="h-20 w-20 flex-shrink-0 cursor-pointer overflow-hidden md:h-32 md:w-32"
                                                onClick={() =>
                                                    setSelectedImage(
                                                        img.image_url,
                                                    )
                                                }
                                            >
                                                <img
                                                    src={img.image_url}
                                                    className="h-full w-full object-cover"
                                                />
                                            </div>
                                        ))}
                                    </div>
                                </div>
                            </div>
                            <div
                                className="grid gap-2 md:gap-4"
                                data-aos="fade-left"
                            >
                                <h2 className="order-2 text-xl font-bold md:order-1 md:text-3xl">
                                    {product.name}
                                </h2>
                                <div
                                    className="order-3 text-xs md:order-2 md:text-base"
                                    dangerouslySetInnerHTML={{
                                        __html: product.description,
                                    }}
                                />
                                <div className="order-1 flex items-center justify-center gap-2 md:order-3 md:justify-start md:gap-5">
                                    <div className="rounded-full bg-[#06A3C7] px-4 py-1">
                                        <p className="text-xs font-semibold md:text-lg">
                                            {`Rp ${Number(product.price).toLocaleString('id-ID')}`}
                                        </p>
                                    </div>
                                    <a
                                        href="https://wa.me/62811429790"
                                        className="flex items-center gap-2 rounded-full border-2 border-solid border-[#4CAF50] px-4 py-1 hover:bg-[#4CAF50] hover:text-white"
                                    >
                                        <img
                                            src={whatsapp}
                                            className="w-4 md:w-5"
                                        />
                                        <p className="text-xs font-medium md:text-base">
                                            Pesan di sini
                                        </p>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </section>
                    <section className="mx-5 mb-7 md:mx-15 md:mb-10">
                        <h3
                            className="mb-3 text-sm font-semibold md:text-base"
                            data-aos="fade-right"
                        >
                            Produk Lainnya
                        </h3>
                        <div className="grid grid-cols-2 gap-3 md:grid-cols-3 md:gap-10">
                            {relatedProducts.map((product) => (
                                <ProductCard product={product} />
                            ))}
                        </div>
                    </section>
                </main>
                <Partnerships data={partnerships} />
                <Footer />
            </div>
        </>
    );
}
