import eo from '@/assets/eo.png';
import img1 from '@/assets/img1.png';
import instagram from '@/assets/instagram.png';
import merch from '@/assets/merch.png';
import party from '@/assets/party.png';
import photo1 from '@/assets/photo1.png';
import photo2 from '@/assets/photo2.png';
import photo3 from '@/assets/photo3.png';
import photo4 from '@/assets/photo4.png';
import tiktok from '@/assets/tiktok.png';
import youtube from '@/assets/youtube.png';
import Footer from '@/components/footer';
import Navbar from '@/components/navbar';
import Partnerships from '@/components/partnerships';
import { Card, CardContent, CardHeader } from '@/components/ui/card';
import { Partnership } from '@/types/partnerships';
import AOS from 'aos';
import 'aos/dist/aos.css';
import { useEffect } from 'react';

interface PartnershipsProps {
    partnerships: Partnership[];
}

export default function Home({ partnerships }: PartnershipsProps) {
    useEffect(() => {
        AOS.init({ duration: 900, once: true });
    }, []);

    return (
        <>
            <div className="flex min-h-screen flex-col">
                <Navbar />
                <main className="flex-1">
                    <section className="mb-5 flex flex-row items-center justify-between gap-0 rounded-2xl bg-[#06A3C7] md:mb-10 md:gap-x-10 md:rounded-4xl">
                        <div
                            className="ml-5 py-2 md:mr-50 md:ml-15"
                            data-aos="fade-right"
                        >
                            <h1 className="text-lg leading-5 font-bold text-white md:text-6xl md:leading-18">
                                Selamat Datang di Perusahaan Jasa Kreatif
                            </h1>
                            <div className="mt-1 w-fit rounded-full bg-gradient-to-r from-[#96F78E] to-[#A2DCEA] px-1 py-0.5 md:mt-10 md:px-5">
                                <p className="text-[7px] font-medium text-black md:text-base">
                                    Solusi terbaik untuk kegiatan kamu
                                </p>
                            </div>
                            <div className="mt-2 flex flex-row gap-2 md:mt-2 md:gap-4">
                                <a href="https://www.tiktok.com/@digitalkreatifagensi1?_t=ZS-90v3PlUeZ8B&_r=1">
                                    <img src={tiktok} className="w-5 md:w-9" />
                                </a>
                                <a href="https://www.instagram.com/digitalkreatifagensi?igsh=anJnMTF4cWZ2enE4">
                                    <img
                                        src={instagram}
                                        className="w-5 md:w-9"
                                    />
                                </a>
                                <a href="https://youtube.com/@digitalkreatifagensi?si=VGJLnkmTAypv46il">
                                    <img src={youtube} className="w-5 md:w-9" />
                                </a>
                            </div>
                        </div>
                        <div
                            className="mr-5 self-end md:mr-15"
                            data-aos="fade-left"
                        >
                            <img src={img1} className="w-80 md:w-300" />
                        </div>
                    </section>
                    <section className="mx-5 mb-7 grid items-center gap-5 md:mx-15 md:mb-10 md:grid-cols-2 md:gap-15">
                        <div className="grid gap-2 md:gap-5">
                            <h2
                                className="text-xl leading-6 font-bold text-[#06A3C7] md:text-5xl md:leading-none"
                                data-aos="fade-right"
                                data-aos-delay="300"
                            >
                                Layanan Event Organizer, Party Planner dan
                                Merchandising
                            </h2>
                            <p
                                className="text-justify text-xs font-medium md:text-xl"
                                data-aos="fade-right"
                            >
                                Sejak berdiri kami telah dipercaya oleh berbagai
                                istansi pemerintah, swasta, hingga individu
                                untuk mewujudkan ide menjadi pengalaman nyata.
                            </p>
                            <a
                                href="/profile"
                                className="w-fit cursor-pointer rounded-full border-1 border-transparent bg-[#06A3C7] px-3 py-1 text-[10px] font-semibold text-white hover:border-solid hover:border-[#06A3C7] hover:bg-white hover:text-[#06A3C7] md:px-4 md:py-1 md:text-base dark:hover:bg-black"
                                data-aos="fade-right"
                            >
                                PROFIL
                            </a>
                        </div>
                        <div
                            className="grid grid-cols-2 justify-items-center gap-3 md:gap-5"
                            data-aos="fade-left"
                            data-aos-delay="300"
                        >
                            <img
                                src={photo1}
                                className="h-35 w-full rounded-3xl object-cover md:h-50"
                            />
                            <img
                                src={photo2}
                                className="h-35 w-full rounded-3xl object-cover md:h-50"
                            />
                            <img
                                src={photo3}
                                className="h-35 w-full rounded-3xl object-cover md:h-50"
                            />
                            <img
                                src={photo4}
                                className="h-35 w-full rounded-3xl object-cover md:h-50"
                            />
                        </div>
                    </section>
                    <section className="mb-7 rounded-4xl bg-[#B2E3EE] md:mb-10 dark:bg-[#13444F]">
                        <h3
                            className="py-5 text-center text-xl font-bold text-[#06A3C7] md:py-10 md:text-3xl dark:text-white"
                            data-aos="zoom-in"
                        >
                            Layanan Kami
                        </h3>
                        <div className="mx-30 grid place-items-center justify-center gap-5 pb-10 md:grid-cols-3 md:gap-16">
                            <Card
                                className="h-full w-60 border-2 border-border bg-card transition-all duration-300 hover:scale-105 hover:border-[#06A3C7] hover:shadow-lg md:w-75"
                                data-aos="fade-right"
                            >
                                <CardHeader className="flex flex-col items-center text-center">
                                    <div className="w-15 md:w-20">
                                        <img src={eo} />
                                    </div>
                                    <h4 className="text-lg font-bold text-[#06A3C7] md:text-2xl">
                                        Event Organizer
                                    </h4>
                                </CardHeader>
                                <CardContent className="text-center text-xs font-medium md:text-base">
                                    <p>
                                        Konsep, perencanaan, produksi, hingga
                                        pelaksanaan acara skala kecil hingga
                                        besar, untuk pemerintahan, perusahaan,
                                        dan publik.
                                    </p>
                                </CardContent>
                            </Card>
                            <Card
                                className="h-full w-60 border-2 border-border bg-card transition-all duration-300 hover:scale-105 hover:border-[#06A3C7] hover:shadow-lg md:w-75"
                                data-aos="fade-up"
                            >
                                <CardHeader className="flex flex-col items-center text-center">
                                    <div className="w-15 md:w-20">
                                        <img src={party} />
                                    </div>
                                    <h4 className="text-lg font-bold text-[#06A3C7] md:text-2xl">
                                        Party Planner
                                    </h4>
                                </CardHeader>
                                <CardContent className="text-center text-xs font-medium md:text-base">
                                    <p>
                                        Perayaan ulang tahun, pesta pernikahan,
                                        hingga private event dengan konsep unik
                                        dan personal.
                                    </p>
                                </CardContent>
                            </Card>
                            <Card
                                className="h-full w-60 border-2 border-border bg-card transition-all duration-300 hover:scale-105 hover:border-[#06A3C7] hover:shadow-lg md:w-75"
                                data-aos="fade-left"
                            >
                                <CardHeader className="flex flex-col items-center text-center">
                                    <div className="w-15 md:w-20">
                                        <img src={merch} />
                                    </div>
                                    <h4 className="text-lg font-bold text-[#06A3C7] md:text-2xl">
                                        Merchandising
                                    </h4>
                                </CardHeader>
                                <CardContent className="text-center text-xs font-medium md:text-base">
                                    <p>
                                        Produksi merchandise kreatif untuk
                                        mendukung branding event, komunitas, dan
                                        perusahaan.
                                    </p>
                                </CardContent>
                            </Card>
                        </div>
                    </section>
                </main>
                <Partnerships data={partnerships} />
                <Footer />
            </div>
        </>
    );
}
