import img3 from '@/assets/img3.png';
import whatsapp from '@/assets/whatsapp.png';
import Footer from '@/components/footer';
import Navbar from '@/components/navbar';
import Partnerships from '@/components/partnerships';
import { Partnership } from '@/types/partnerships';
import AOS from 'aos';
import 'aos/dist/aos.css';
import { ChevronRight, Instagram, Mail, MapPin, Phone } from 'lucide-react';
import { useEffect } from 'react';

interface ContactsProps {
    partnerships: Partnership[];
}

export default function Contacts({ partnerships }: ContactsProps) {
    useEffect(() => {
        AOS.init({ duration: 900, once: true });
    }, []);

    return (
        <>
            <div className="flex min-h-screen flex-col">
                <Navbar />
                <main className="flex-1">
                    <section className="mx-5 mt-2 mb-7 flex flex-col justify-between gap-4 md:mx-15 md:mb-10 md:flex-row">
                        <div
                            className="flex flex-col gap-3 md:gap-5 md:pr-30"
                            data-aos="fade-right"
                        >
                            <h3 className="text-xl font-bold text-[#06A3C7] md:text-5xl">
                                Rencanakan, rayakan, dan kenang setiap momen
                                dengan istimewa
                            </h3>
                            <p className="text-justify text-sm font-medium md:text-lg">
                                Hubungi kami sekarang dan mari mulai mewujudkan
                                ide Anda menjadi sebuah pengalaman tak
                                terlupakan!
                            </p>
                            <a
                                href="https://wa.me/62811429790"
                                className="flex w-fit items-center gap-2 rounded-full border-2 border-solid border-[#4CAF50] px-3 py-1 hover:bg-[#4CAF50] hover:text-white md:px-5"
                            >
                                <img src={whatsapp} className="w-4 md:w-5" />
                                <p className="text-xs font-medium md:text-base">
                                    Whatsapp
                                </p>
                                <ChevronRight className="h-4 w-4 md:h-6 md:w-6" />
                            </a>
                        </div>
                        <div className="w-full md:w-200" data-aos="fade-left">
                            <img src={img3} className="object-cover" />
                        </div>
                    </section>
                    <section className="mx-5 mb-7 grid gap-5 md:mx-15 md:mb-10 md:grid-cols-3">
                        <div
                            className="col-span-1 flex flex-col gap-3 md:gap-5"
                            data-aos="fade-right"
                        >
                            <h3 className="text-lg font-bold md:text-4xl">
                                <span className="text-[#06A3C7]">Kontak </span>
                                <span className="text-[#96F78E]">Kami</span>
                            </h3>
                            <li className="flex items-center gap-2 md:gap-4">
                                <MapPin className="h-5 w-5 flex-shrink-0 text-[#06A3C7] md:h-8 md:w-8" />
                                <a
                                    href="https://maps.app.goo.gl/wBA3Le4is4V2orh57"
                                    className="text-xs font-medium hover:underline md:text-lg"
                                >
                                    Jl. Kelapa, Kota Palopo
                                </a>
                            </li>
                            <li className="flex items-center gap-2 md:gap-4">
                                <Phone className="h-5 w-5 flex-shrink-0 text-[#06A3C7] md:h-8 md:w-8" />
                                <a
                                    href="https://wa.me/62811429790"
                                    className="text-xs font-medium hover:underline md:text-lg"
                                >
                                    +62 811-429-790
                                </a>
                            </li>
                            <li className="flex items-center gap-2 md:gap-4">
                                <Mail className="h-5 w-5 flex-shrink-0 text-[#06A3C7] md:h-8 md:w-8" />
                                <a
                                    href="mailto:digitalkreatifagency@gmail.com"
                                    className="text-xs font-medium hover:underline md:text-lg"
                                >
                                    digitalkreatifagency@gmail.com
                                </a>
                            </li>
                            <li className="flex items-center gap-2 md:gap-4">
                                <Instagram className="h-5 w-5 flex-shrink-0 text-[#06A3C7] md:h-8 md:w-8" />
                                <a
                                    href="https://www.instagram.com/digitalkreatifagensi/"
                                    className="text-xs font-medium hover:underline md:text-lg"
                                >
                                    @digitalkreatifagensi
                                </a>
                            </li>
                        </div>
                        <div
                            className="col-span-2 h-75 shadow-[0_0_8px_#96F78E] md:h-100 md:shadow-[0_0_15px_#96F78E]"
                            data-aos="fade-left"
                        >
                            <iframe
                                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d249.02075416836212!2d120.1921291795107!3d-3.005029842534968!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2d915f00534fe4d1%3A0xcca77ce3c55fb66a!2sDigital%20Kreatif%20Agensi!5e0!3m2!1sid!2sid!4v1763088713465!5m2!1sid!2sid"
                                style={{ border: 0 }}
                                allowFullScreen
                                loading="lazy"
                                referrerPolicy="no-referrer-when-downgrade"
                                className="h-full w-full"
                            />
                        </div>
                    </section>
                </main>
                <Partnerships data={partnerships} />
                <Footer />
            </div>
        </>
    );
}
