import ad from '@/assets/ad.png';
import ArticleCard from '@/components/article-card';
import Footer from '@/components/footer';
import Navbar from '@/components/navbar';
import Partnerships from '@/components/partnerships';
import { Article, DetailArticle as detailArticle } from '@/types/articles';
import { Partnership } from '@/types/partnerships';
import AOS from 'aos';
import 'aos/dist/aos.css';
import { CalendarDays, ChevronLeft, UserRound } from 'lucide-react';
import { useEffect } from 'react';

interface DetailArticleProps {
    detailArticle: detailArticle;
    relatedArticles: Article[];
    partnerships: Partnership[];
}

export default function DetailArticle({
    detailArticle,
    relatedArticles,
    partnerships,
}: DetailArticleProps) {
    useEffect(() => {
        AOS.init({ duration: 900, once: true });
    }, []);

    return (
        <>
            <div className="flex min-h-screen flex-col">
                <Navbar />
                <main className="flex-1">
                    <section className="mx-5 mt-5 mb-10 md:mx-15">
                        <a
                            className="inline-flex items-center gap-1 text-[#06A3C7] hover:text-[#696969] dark:hover:text-[#D3D3D3]"
                            href="/articles/all"
                        >
                            <ChevronLeft className="w-4 md:w-5" />
                            <p className="text-xs font-medium md:text-base">
                                Kembali
                            </p>
                        </a>
                        <div className="mt-1 flex flex-col items-start gap-4 md:mt-5 md:flex-row md:gap-6">
                            <div
                                className="mb-auto grid flex-[3] gap-2 md:gap-4"
                                data-aos="fade-right"
                            >
                                <h2 className="text-justify text-lg/6 font-bold text-[#06A3C7] md:text-3xl">
                                    {detailArticle.title}
                                </h2>
                                <div className="flex items-center gap-8">
                                    <div className="flex items-center gap-1">
                                        <CalendarDays className="h-3 w-3 text-[#06A3C7] md:h-5 md:w-5" />
                                        <p className="pt-1 text-[10px] font-medium md:text-sm">
                                            {new Date(
                                                detailArticle.created_at,
                                            ).toLocaleDateString('id-ID', {
                                                day: 'numeric',
                                                month: 'long',
                                                year: 'numeric',
                                            })}
                                        </p>
                                    </div>
                                    <div className="flex items-center gap-1">
                                        <UserRound className="h-3 w-3 text-[#06A3C7] md:h-5 md:w-5" />
                                        <p className="pt-1 text-[10px] font-medium md:text-sm">
                                            Admin
                                        </p>
                                    </div>
                                </div>
                                <div className="relative flex h-50 w-full justify-center overflow-hidden rounded-lg md:h-100 md:rounded-2xl">
                                    <img
                                        src={detailArticle.image_url}
                                        className="h-full object-cover transition-transform"
                                    />
                                </div>
                                <div
                                    className="text-justify text-[10px]/5 md:text-base/7 [&_p]:mb-4"
                                    dangerouslySetInnerHTML={{
                                        __html: detailArticle.description,
                                    }}
                                />
                            </div>
                            <div
                                className="flex flex-[1] flex-col gap-4"
                                data-aos="fade-left"
                            >
                                <div className="flex flex-col gap-3">
                                    {relatedArticles.length > 0 ? (
                                        relatedArticles.map((article) => (
                                            <ArticleCard article={article} />
                                        ))
                                    ) : (
                                        <p>Tidak ada artikel lainnya.</p>
                                    )}
                                </div>
                                <div className="flex items-center justify-center">
                                    <a
                                        href="/articles/all"
                                        className="w-full cursor-pointer rounded-full border-2 border-transparent bg-[#06A3C7] py-1 text-center text-xs font-medium text-white hover:border-solid hover:border-[#06A3C7] hover:bg-white hover:text-[#06A3C7] md:text-base dark:hover:bg-black"
                                    >
                                        Lihat semua artikel
                                    </a>
                                </div>
                                <div className="w-full self-center md:w-75">
                                    <img src={ad} />
                                </div>
                            </div>
                        </div>
                    </section>
                </main>
                <Partnerships data={partnerships} />
                <Footer />
            </div>
        </>
    );
}
