import { Product } from '@/types/products';

interface ProductCardProps {
    product: Product;
}

const ProductCard = ({ product }: ProductCardProps) => {
    return (
        <div className="flex flex-col gap-1.5 md:gap-3" data-aos="zoom-in">
            <div className="relative flex">
                <div className="relative w-full overflow-hidden rounded-xl bg-[#DEDAD1] md:rounded-2xl">
                    <img
                        src={product.main_image}
                        className="h-30 w-full object-cover transition-transform duration-300 hover:scale-120 md:h-50"
                    />
                </div>
                <p className="absolute left-0 rounded-tl-full rounded-r-full bg-gradient-to-r from-[#7DD0E2] to-[#C7FBC4] px-3 py-1 text-xs font-medium text-black md:px-5 md:text-base">
                    {product.name}
                </p>
            </div>
            <div className="flex items-center justify-between md:flex-row">
                <p className="text-[11px] font-semibold md:text-xl">
                    {`Rp ${Number(product.price).toLocaleString('id-ID')}`}
                </p>
                <a
                    href={`/products/${product.id}`}
                    className="cursor-pointer rounded-full bg-gradient-to-r from-[#7DD0E2] to-[#C7FBC4] px-1 py-1 text-[9px] font-medium text-black hover:scale-105 md:px-7 md:text-base"
                >
                    Detail produk
                </a>
            </div>
        </div>
    );
};

export default ProductCard;
