import { Partnership } from '@/types/partnerships';

interface PartnershipsProps {
    data: Partnership[];
}

const Partnerships = ({ data }: PartnershipsProps) => {
    return (
        <section className="mb-5 overflow-x-hidden md:mb-10">
            <div className="h-1 bg-[#06A3C7]"></div>
            <div className="relative">
                <h3
                    className="mx-5 py-3 text-xs font-semibold md:mx-15 md:text-base"
                    data-aos="fade-right"
                >
                    Partnership:
                </h3>
                <div
                    className="animate-scroll-left flex w-max gap-3 md:gap-5"
                    data-aos="zoom-in"
                    data-aos-delay="200"
                >
                    {[...data, ...data, ...data].map((partner) => (
                        <img
                            src={partner.image_url}
                            className="h-20 object-contain md:h-35"
                        />
                    ))}
                </div>
            </div>
        </section>
    );
};

export default Partnerships;
