import logodka from '@/assets/logo-dka.png';
import { Button } from '@/components/ui/button';
import { router } from '@inertiajs/react';
import { Menu, Moon, Sun, X } from 'lucide-react';
import { useEffect, useState } from 'react';

const Navbar = () => {
    const [theme, setTheme] = useState(
        localStorage.getItem('theme') || 'system',
    );
    const [isMenuOpen, setIsMenuOpen] = useState(false);

    useEffect(() => {
        const root = document.documentElement;
        if (theme === 'dark') {
            root.classList.add('dark');
        } else {
            root.classList.remove('dark');
        }
        localStorage.setItem('theme', theme);
    }, [theme]);

    return (
        <nav className="sticky top-0 z-50 bg-background/95">
            <div className="mx-5 flex items-center justify-between py-2 md:mx-15">
                <div
                    className="flex cursor-pointer flex-row items-center gap-2 md:gap-3"
                    onClick={() => router.visit('/')}
                >
                    <div className="w-8 md:w-11">
                        <img src={logodka} alt="Logo" />
                    </div>
                    <div className="flex flex-col -space-y-1 md:-space-y-1.5">
                        <span className="text-[10px] font-bold md:text-sm">
                            DIGITAL
                        </span>
                        <span className="text-[10px] font-bold md:text-sm">
                            KREATIF
                        </span>
                        <span className="text-[10px] font-bold md:text-sm">
                            AGENCY
                        </span>
                    </div>
                </div>

                <div className="hidden items-center gap-6 md:flex">
                    <a
                        href="/"
                        className="rounded-4xl px-3 py-1 font-medium text-foreground transition-colors hover:bg-[#E6E6E6] dark:hover:bg-[#5E5E5E]"
                    >
                        Beranda
                    </a>
                    <a
                        href="/products"
                        className="rounded-4xl px-3 py-1 font-medium text-foreground transition-colors hover:bg-[#E6E6E6] dark:hover:bg-[#5E5E5E]"
                    >
                        Produk
                    </a>
                    <a
                        href="/articles"
                        className="rounded-4xl px-3 py-1 font-medium text-foreground transition-colors hover:bg-[#E6E6E6] dark:hover:bg-[#5E5E5E]"
                    >
                        Artikel
                    </a>
                    <a
                        href="/profile"
                        className="rounded-4xl px-3 py-1 font-medium text-foreground transition-colors hover:bg-[#E6E6E6] dark:hover:bg-[#5E5E5E]"
                    >
                        Profil
                    </a>
                    <a
                        href="/contacts"
                        className="rounded-4xl px-3 py-1 font-medium text-foreground transition-colors hover:bg-[#E6E6E6] dark:hover:bg-[#5E5E5E]"
                    >
                        Kontak
                    </a>
                </div>

                <div className="flex items-center gap-2 md:gap-3">
                    <Button
                        variant="outline"
                        size="icon"
                        onClick={() =>
                            setTheme(theme === 'dark' ? 'light' : 'dark')
                        }
                        className="h-8 w-8 rounded-full md:h-10 md:w-10"
                    >
                        {theme === 'dark' ? (
                            <Sun className="h-4 w-4 md:h-5 md:w-5" />
                        ) : (
                            <Moon className="h-4 w-4 md:h-5 md:w-5" />
                        )}
                    </Button>

                    <button
                        onClick={() => setIsMenuOpen(!isMenuOpen)}
                        className="rounded-full p-1 hover:bg-[#E6E6E6] md:hidden dark:hover:bg-[#5E5E5E]"
                    >
                        {isMenuOpen ? (
                            <X className="h-5 w-5 text-foreground" />
                        ) : (
                            <Menu className="h-5 w-5 text-foreground" />
                        )}
                    </button>
                </div>
            </div>

            {isMenuOpen && (
                <div className="flex flex-col items-center gap-2 pb-4 md:hidden">
                    <a
                        href="/"
                        className="w-full rounded-3xl py-2 text-center text-sm font-medium text-foreground transition-colors hover:bg-[#E6E6E6] dark:hover:bg-[#5E5E5E]"
                    >
                        Beranda
                    </a>
                    <a
                        href="/products"
                        className="w-full rounded-3xl py-2 text-center text-sm font-medium text-foreground transition-colors hover:bg-[#E6E6E6] dark:hover:bg-[#5E5E5E]"
                    >
                        Produk
                    </a>
                    <a
                        href="/articles"
                        className="w-full rounded-3xl py-2 text-center text-sm font-medium text-foreground transition-colors hover:bg-[#E6E6E6] dark:hover:bg-[#5E5E5E]"
                    >
                        Artikel
                    </a>
                    <a
                        href="/profile"
                        className="w-full rounded-3xl py-2 text-center text-sm font-medium text-foreground transition-colors hover:bg-[#E6E6E6] dark:hover:bg-[#5E5E5E]"
                    >
                        Profil
                    </a>
                    <a
                        href="/contacts"
                        className="w-full rounded-3xl py-2 text-center text-sm font-medium text-foreground transition-colors hover:bg-[#E6E6E6] dark:hover:bg-[#5E5E5E]"
                    >
                        Kontak
                    </a>
                </div>
            )}
        </nav>
    );
};

export default Navbar;
