import instagram from '@/assets/instagram.png';
import logodka from '@/assets/logo-dka.png';
import tiktok from '@/assets/tiktok.png';
import youtube from '@/assets/youtube.png';
import { Clock, Mail, MapPin, Phone } from 'lucide-react';

const Footer = () => {
    return (
        <footer className="bg-[#1A1A1A] dark:bg-white">
            <div className="mx-5 grid gap-5 pt-5 md:mx-15 md:grid-cols-[2fr_1fr_1fr] md:gap-0">
                <div className="flex gap-3 md:pr-15">
                    <img src={logodka} className="h-10 pt-1" />
                    <div>
                        <div className="flex gap-1">
                            <h2 className="text-lg font-bold text-[#06A3C7]">
                                Digital Kreatif
                            </h2>
                            <h2 className="text-lg font-bold text-[#96F78E] dark:text-[#06A3C7]">
                                Agency
                            </h2>
                        </div>
                        <p className="mt-1 text-justify text-xs text-white md:text-left md:text-sm dark:text-black">
                            Digital Kreatif Agensi adalah perusahaan yang
                            bergerak di bidang Event Organizer, Party Planner,
                            dan Merchandising.
                        </p>
                        <div className="mt-2 flex gap-3 md:mt-5">
                            <a href="https://www.tiktok.com/@digitalkreatifagensi1?_t=ZS-90v3PlUeZ8B&_r=1">
                                <img
                                    src={tiktok}
                                    className="w-6 md:w-8 dark:invert"
                                />
                            </a>
                            <a href="https://www.instagram.com/digitalkreatifagensi?igsh=anJnMTF4cWZ2enE4">
                                <img
                                    src={instagram}
                                    className="w-6 md:w-8 dark:invert"
                                />
                            </a>
                            <a href="https://youtube.com/@digitalkreatifagensi?si=VGJLnkmTAypv46il">
                                <img
                                    src={youtube}
                                    className="w-6 md:w-8 dark:invert"
                                />
                            </a>
                        </div>
                    </div>
                </div>
                <div className="flex flex-col gap-2 md:gap-3">
                    <p className="flex text-sm font-semibold text-white md:text-base dark:text-black">
                        Menu Utama
                    </p>
                    <div className="flex flex-col gap-1">
                        <a
                            href="/"
                            className="w-fit text-xs font-medium text-[#5D73FF] md:text-sm"
                        >
                            Beranda
                        </a>
                        <a
                            href="/products"
                            className="w-fit text-xs font-medium text-[#5D73FF] md:text-sm"
                        >
                            Produk
                        </a>
                        <a
                            href="/articles"
                            className="w-fit text-xs font-medium text-[#5D73FF] md:text-sm"
                        >
                            Artikel
                        </a>
                        <a
                            href="/profile"
                            className="w-fit text-xs font-medium text-[#5D73FF] md:text-sm"
                        >
                            Profil
                        </a>
                    </div>
                </div>
                <div className="flex flex-col gap-2 md:gap-3">
                    <h4 className="text-sm font-semibold text-white md:text-base dark:text-black">
                        Kontak
                    </h4>
                    <ul className="space-y-3">
                        <li className="flex items-center gap-2">
                            <MapPin className="h-4 w-4 flex-shrink-0 text-white md:h-5 md:w-5 dark:text-black" />
                            <span className="text-xs font-medium text-white md:text-sm dark:text-black">
                                Jl. Kelapa, Kota Palopo
                            </span>
                        </li>
                        <li className="flex items-center gap-2">
                            <Phone className="h-4 w-4 flex-shrink-0 text-primary text-white md:h-5 md:w-5 dark:text-black" />
                            <span className="text-xs font-medium text-white md:text-sm dark:text-black">
                                +62 811-429-790
                            </span>
                        </li>
                        <li className="flex items-center gap-2">
                            <Mail className="h-4 w-4 flex-shrink-0 text-primary text-white md:h-5 md:w-5 dark:text-black" />
                            <span className="text-xs font-medium text-white md:text-sm dark:text-black">
                                digitalkreatifagency@gmail.com
                            </span>
                        </li>
                        <li className="flex items-center gap-2">
                            <Clock className="h-4 w-4 flex-shrink-0 text-primary text-white md:h-5 md:w-5 dark:text-black" />
                            <span className="text-xs font-medium text-white md:text-sm dark:text-black">
                                09:00-14:00 WITA
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
            <div className="flex-cols mx-5 mt-5 flex justify-between border-t-3 border-white pb-2 md:mx-15 dark:border-black">
                <p className="mt-1 text-[10px] text-white md:text-xs dark:text-black">
                    © Kota Palopo. All rights reserved.
                </p>
                <p className="mt-1 text-xs text-[10px] text-white md:text-xs dark:text-black">
                    DigitalKreatifAgency2025
                </p>
            </div>
        </footer>
    );
};

export default Footer;
