import { Article } from '@/types/articles';
import { CalendarDays, UserRound } from 'lucide-react';

interface ArticleCardProps {
    article: Article;
}

const ArticleCard = ({ article }: ArticleCardProps) => {
    return (
        <div className="flex gap-3">
            <div className="h-27 w-30 flex-shrink-0 overflow-hidden rounded-lg md:h-32 md:w-35 md:rounded-2xl">
                <img
                    src={article.image_url}
                    className="h-full w-full object-cover"
                />
            </div>
            <div className="grid">
                <div className="flex items-center gap-1">
                    <CalendarDays className="h-3 w-3 text-[#06A3C7] md:h-3.5 md:w-3.5" />
                    <p className="pt-0.5 text-[10px] md:text-xs">
                        {new Date(article.created_at).toLocaleDateString(
                            'id-ID',
                            {
                                day: 'numeric',
                                month: 'long',
                                year: 'numeric',
                            },
                        )}
                    </p>
                </div>
                <a
                    href={`/articles/${article.slug}`}
                    className="text-[11px] font-semibold hover:underline hover:decoration-[#06A3C7] hover:decoration-2 hover:underline-offset-[3px] md:text-sm"
                >
                    {article.title.length > 85
                        ? article.title.slice(0, 85) + '...'
                        : article.title}
                </a>
                <div className="flex items-center gap-1">
                    <UserRound className="h-3 w-3 text-[#06A3C7] md:h-3.5 md:w-3.5" />
                    <p className="pt-0.5 text-[10px] md:text-xs">Admin</p>
                </div>
            </div>
        </div>
    );
};

export default ArticleCard;
