import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Web\ArticleController::index
 * @see app/Http/Controllers/Web/ArticleController.php:14
 * @route '/articles'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/articles',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Web\ArticleController::index
 * @see app/Http/Controllers/Web/ArticleController.php:14
 * @route '/articles'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Web\ArticleController::index
 * @see app/Http/Controllers/Web/ArticleController.php:14
 * @route '/articles'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\Web\ArticleController::index
 * @see app/Http/Controllers/Web/ArticleController.php:14
 * @route '/articles'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\Web\ArticleController::index
 * @see app/Http/Controllers/Web/ArticleController.php:14
 * @route '/articles'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\Web\ArticleController::index
 * @see app/Http/Controllers/Web/ArticleController.php:14
 * @route '/articles'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\Web\ArticleController::index
 * @see app/Http/Controllers/Web/ArticleController.php:14
 * @route '/articles'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\Web\ArticleController::all
 * @see app/Http/Controllers/Web/ArticleController.php:102
 * @route '/articles/all'
 */
export const all = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: all.url(options),
    method: 'get',
})

all.definition = {
    methods: ["get","head"],
    url: '/articles/all',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Web\ArticleController::all
 * @see app/Http/Controllers/Web/ArticleController.php:102
 * @route '/articles/all'
 */
all.url = (options?: RouteQueryOptions) => {
    return all.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Web\ArticleController::all
 * @see app/Http/Controllers/Web/ArticleController.php:102
 * @route '/articles/all'
 */
all.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: all.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\Web\ArticleController::all
 * @see app/Http/Controllers/Web/ArticleController.php:102
 * @route '/articles/all'
 */
all.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: all.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\Web\ArticleController::all
 * @see app/Http/Controllers/Web/ArticleController.php:102
 * @route '/articles/all'
 */
    const allForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: all.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\Web\ArticleController::all
 * @see app/Http/Controllers/Web/ArticleController.php:102
 * @route '/articles/all'
 */
        allForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: all.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\Web\ArticleController::all
 * @see app/Http/Controllers/Web/ArticleController.php:102
 * @route '/articles/all'
 */
        allForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: all.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    all.form = allForm
/**
* @see \App\Http\Controllers\Web\ArticleController::detail
 * @see app/Http/Controllers/Web/ArticleController.php:54
 * @route '/articles/{slug}'
 */
export const detail = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: detail.url(args, options),
    method: 'get',
})

detail.definition = {
    methods: ["get","head"],
    url: '/articles/{slug}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Web\ArticleController::detail
 * @see app/Http/Controllers/Web/ArticleController.php:54
 * @route '/articles/{slug}'
 */
detail.url = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { slug: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    slug: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        slug: args.slug,
                }

    return detail.definition.url
            .replace('{slug}', parsedArgs.slug.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Web\ArticleController::detail
 * @see app/Http/Controllers/Web/ArticleController.php:54
 * @route '/articles/{slug}'
 */
detail.get = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: detail.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\Web\ArticleController::detail
 * @see app/Http/Controllers/Web/ArticleController.php:54
 * @route '/articles/{slug}'
 */
detail.head = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: detail.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\Web\ArticleController::detail
 * @see app/Http/Controllers/Web/ArticleController.php:54
 * @route '/articles/{slug}'
 */
    const detailForm = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: detail.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\Web\ArticleController::detail
 * @see app/Http/Controllers/Web/ArticleController.php:54
 * @route '/articles/{slug}'
 */
        detailForm.get = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: detail.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\Web\ArticleController::detail
 * @see app/Http/Controllers/Web/ArticleController.php:54
 * @route '/articles/{slug}'
 */
        detailForm.head = (args: { slug: string | number } | [slug: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: detail.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    detail.form = detailForm
const ArticleController = { index, all, detail }

export default ArticleController