import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\Partnerships\Pages\EditPartnerships::__invoke
 * @see app/Filament/Resources/Partnerships/Pages/EditPartnerships.php:7
 * @route '/admin/partnerships/{record}/edit'
 */
const EditPartnerships = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: EditPartnerships.url(args, options),
    method: 'get',
})

EditPartnerships.definition = {
    methods: ["get","head"],
    url: '/admin/partnerships/{record}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\Partnerships\Pages\EditPartnerships::__invoke
 * @see app/Filament/Resources/Partnerships/Pages/EditPartnerships.php:7
 * @route '/admin/partnerships/{record}/edit'
 */
EditPartnerships.url = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { record: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    record: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        record: args.record,
                }

    return EditPartnerships.definition.url
            .replace('{record}', parsedArgs.record.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Filament\Resources\Partnerships\Pages\EditPartnerships::__invoke
 * @see app/Filament/Resources/Partnerships/Pages/EditPartnerships.php:7
 * @route '/admin/partnerships/{record}/edit'
 */
EditPartnerships.get = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: EditPartnerships.url(args, options),
    method: 'get',
})
/**
* @see \App\Filament\Resources\Partnerships\Pages\EditPartnerships::__invoke
 * @see app/Filament/Resources/Partnerships/Pages/EditPartnerships.php:7
 * @route '/admin/partnerships/{record}/edit'
 */
EditPartnerships.head = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: EditPartnerships.url(args, options),
    method: 'head',
})

    /**
* @see \App\Filament\Resources\Partnerships\Pages\EditPartnerships::__invoke
 * @see app/Filament/Resources/Partnerships/Pages/EditPartnerships.php:7
 * @route '/admin/partnerships/{record}/edit'
 */
    const EditPartnershipsForm = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: EditPartnerships.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Filament\Resources\Partnerships\Pages\EditPartnerships::__invoke
 * @see app/Filament/Resources/Partnerships/Pages/EditPartnerships.php:7
 * @route '/admin/partnerships/{record}/edit'
 */
        EditPartnershipsForm.get = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: EditPartnerships.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Filament\Resources\Partnerships\Pages\EditPartnerships::__invoke
 * @see app/Filament/Resources/Partnerships/Pages/EditPartnerships.php:7
 * @route '/admin/partnerships/{record}/edit'
 */
        EditPartnershipsForm.head = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: EditPartnerships.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    EditPartnerships.form = EditPartnershipsForm
export default EditPartnerships