import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\Articles\Pages\EditArticle::__invoke
 * @see app/Filament/Resources/Articles/Pages/EditArticle.php:7
 * @route '/admin/articles/{record}/edit'
 */
const EditArticle = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: EditArticle.url(args, options),
    method: 'get',
})

EditArticle.definition = {
    methods: ["get","head"],
    url: '/admin/articles/{record}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\Articles\Pages\EditArticle::__invoke
 * @see app/Filament/Resources/Articles/Pages/EditArticle.php:7
 * @route '/admin/articles/{record}/edit'
 */
EditArticle.url = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { record: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    record: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        record: args.record,
                }

    return EditArticle.definition.url
            .replace('{record}', parsedArgs.record.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Filament\Resources\Articles\Pages\EditArticle::__invoke
 * @see app/Filament/Resources/Articles/Pages/EditArticle.php:7
 * @route '/admin/articles/{record}/edit'
 */
EditArticle.get = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: EditArticle.url(args, options),
    method: 'get',
})
/**
* @see \App\Filament\Resources\Articles\Pages\EditArticle::__invoke
 * @see app/Filament/Resources/Articles/Pages/EditArticle.php:7
 * @route '/admin/articles/{record}/edit'
 */
EditArticle.head = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: EditArticle.url(args, options),
    method: 'head',
})

    /**
* @see \App\Filament\Resources\Articles\Pages\EditArticle::__invoke
 * @see app/Filament/Resources/Articles/Pages/EditArticle.php:7
 * @route '/admin/articles/{record}/edit'
 */
    const EditArticleForm = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: EditArticle.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Filament\Resources\Articles\Pages\EditArticle::__invoke
 * @see app/Filament/Resources/Articles/Pages/EditArticle.php:7
 * @route '/admin/articles/{record}/edit'
 */
        EditArticleForm.get = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: EditArticle.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Filament\Resources\Articles\Pages\EditArticle::__invoke
 * @see app/Filament/Resources/Articles/Pages/EditArticle.php:7
 * @route '/admin/articles/{record}/edit'
 */
        EditArticleForm.head = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: EditArticle.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    EditArticle.form = EditArticleForm
export default EditArticle