<?php

namespace Database\Seeders;

use App\Models\Product;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Product::truncate();

        $products = [
            [
                'name' => 'Lanyard',
                'main_image' => 'product/01K96EREKYCHH6K1EYDP5S536W.png',
                'description' => '<p>lanyard ini cocok untuk kebutuhan ID card, event, kantor, promosi brand, maupun merchandise perusahaan. <br>Kelebihan:</p><ul><li><p>Tampilan premium: permukaan halus dan mengkilap memberikan kesan elegan.</p></li><li><p>Nyaman dipakai: lembut di kulit, tidak mudah membuat leher iritasi.</p></li><li><p>Tahan lama: serat polyester kuat dan tidak mudah sobek.</p></li><li><p>Warna awet: hasil sablon atau printing tidak cepat luntur meski sering digunakan.</p></li><li><p>Custom penuh: bisa dicetak logo, nama, atau desain sesuai keinginan.</p></li></ul>',
                'price' => 15000.00
            ],

            [
                'name' => 'Vest',
                'main_image' => 'product/01K96KF348YDQP9Q6FS9YASSXR.png',
                'description' => '<p>Cocok digunakan untuk seragam kerja, event outdoor, komunitas, hingga promosi brand.</p><p>Kelebihan:</p><ul><li><p>Bahan kuat dan tahan air: Taslan memiliki daya tahan tinggi terhadap cuaca, cocok untuk kegiatan luar ruangan.</p></li><li><p>Ringan dan nyaman: meski kuat, bahannya tetap ringan saat dipakai seharian.</p></li><li><p>Sirkulasi udara baik: tetap terasa adem, tidak panas meski digunakan lama.</p></li><li><p>Tampilan profesional: jahitan rapi dan bisa dicustom dengan bordir atau sablon logo.</p></li><li><p>Tersedia berbagai warna dan ukuran: bisa disesuaikan dengan kebutuhan tim atau perusahaan.</p></li></ul>',
                'price' => 15000.00
            ],

            [
                'name' => 'Kaos',
                'main_image' => 'product/01K96KNMN8R5ZBJ98RTEM7EXRJ.png',
                'description' => '<p>kaos ini cocok digunakan untuk seragam komunitas, merchandise, promosi, event, maupun pakaian casual.</p><p>Kelebihan:</p><ul><li><p>Nyaman di kulit: bahan 100% katun halus, tidak panas, dan tidak mudah menyebabkan iritasi.</p></li><li><p>Daya serap tinggi: menyerap keringat dengan baik, cocok untuk aktivitas indoor maupun outdoor.</p></li><li><p>Tidak mudah melar atau kusut: serat kain kuat dan tetap rapi meski sering dicuci.</p></li><li><p>Cocok untuk sablon dan bordir: hasil cetak lebih tajam dan tahan lama.</p></li><li><p>Bisa custom desain: tersedia pilihan ukuran dan warna sesuai kebutuhan.</p></li></ul>',
                'price' => 15000.00
            ],

            [
                'name' => 'Mug',
                'main_image' => 'product/01K96KV7BEBEE3MYREECE0BMJW.png',
                'description' => '<p>Cocok untuk souvenir, hadiah, merchandise perusahaan, atau perlengkapan promosi.</p><p>Kelebihan:</p><ul><li><p>Bahan keramik premium: tebal, kuat, dan tahan panas.</p></li><li><p>Cetakan awet: desain tidak mudah luntur meskipun sering dicuci.</p></li><li><p>Tampilan elegan: permukaan glossy membuat warna desain terlihat lebih hidup.</p></li><li><p>Bisa custom penuh: logo, nama, foto, atau desain bebas sesuai permintaan.</p></li><li><p>Cocok untuk berbagai acara: ideal untuk promosi, hadiah ulang tahun, atau kenangkenangan event.</p></li></ul>',
                'price' => 15000.00
            ],

            [
                'name' => 'Totebag',
                'main_image' => 'product/01K96KZ38QC0CAPEN0R8T9G7JA.jpeg',
                'description' => '<p>cocok digunakan untuk aktivitas sehari-hari, souvenir event, merchandise brand, maupun hadiah custom. Proses sablon atau printing dilakukan dengan hasil cetak yang tajam dan tidak mudah pudar.</p><p>Kelebihan:</p><ul><li><p>Bahan tebal dan kuat: mampu menampung beban berat tanpa mudah robek.</p></li><li><p>Ramah lingkungan: bisa digunakan berulang kali, pengganti kantong plastik sekali pakai.</p></li><li><p>Tampilan stylish: cocok untuk semua kalangan dan berbagai kegiatan.</p></li><li><p>Custom desain penuh: bisa dicetak logo, tulisan, atau gambar sesuai keinginan.</p></li><li><p>Perawatan mudah: cukup dicuci manual dan dikeringkan di tempat teduh.</p></li></ul>',
                'price' => 15000.00
            ],

            [
                'name' => 'Tumbler',
                'main_image' => 'product/01K970JJ7G7G3CJNXFSFDQ5ZYE.png',
                'description' => '<p>sangat cocok untuk souvenir perusahaan, hadiah, merchandise event, maupun penggunaan pribadi.</p><p>🌟 Kelebihan:</p><ul><li><p>Menjaga suhu minuman lebih lama: mampu mempertahankan panas atau dingin hingga berjam-jam.</p></li><li><p>Bahan kuat dan tahan karat: tidak mudah penyok atau berbau seperti plastik.</p></li><li><p>Desain elegan &amp; modern: cocok untuk segala kalangan, dari kantor hingga kegiatan outdoor.</p></li><li><p>Custom logo atau nama: bisa dicetak sesuai kebutuhan promosi atau personal gift.</p></li><li><p>Ramah lingkungan: bisa dipakai berulang kali, membantu mengurangi sampah botol plastik.</p></li></ul>',
                'price' => 15000.00
            ],

            [
                'name' => 'Kopi DKA',
                'main_image' => 'product/01K9BN606TWVVYKRYT8P0T3Q3G.png',
                'description' => '<p>Rasakan pengalaman kopi premium yang dibuat dari biji kopi terbaik, dipanen dari dataran tinggi pilihan, dan diproses dengan standar kualitas tertinggi. Kopi kami dirancang untuk memberikan energi yang <em>powerful</em> dan kehangatan yang menenangkan di setiap tegukan, menjadikannya teman sempurna untuk memulai hari atau meningkatkan fokus Anda.</p><p></p><h3>Kelebihan Produk (The Strengths)</h3><p></p><ul><li><p><strong>Aroma &amp; Rasa Kaya (Rich Flavor &amp; Aroma):</strong> Kopi kami menyajikan profil rasa yang seimbang, dengan <strong>aroma yang intens</strong> dan nuansa rasa yang kompleks (mulai dari <em>chocolatey</em>, <em>nutty</em>, hingga <em>fruity</em>), tergantung pada varietas biji.</p></li><li><p><strong>Kafein Alami Efektif (Effective Natural Caffeine):</strong> Menyediakan dorongan energi yang <strong>bersih dan berkelanjutan</strong> tanpa efek <em>jitters</em> berlebihan, ideal untuk meningkatkan <strong>fokus dan produktivitas</strong>.</p></li><li><p><strong>Kualitas &amp; Kesejukan Terjamin (Guaranteed Quality &amp; Freshness):</strong> Kami menjamin <strong>kesejukan maksimal</strong> melalui proses <em>roasting</em> (sangrai) yang terkontrol dan kemasan kedap udara, menjaga kualitas biji kopi hingga tiba di tangan Anda.</p></li><li><p><strong>Serbaguna (Versatile Use):</strong> Cocok disajikan dalam berbagai metode seduh, baik panas (V60, French Press) maupun dingin (Cold Brew), memberikan fleksibilitas sesuai preferensi Anda.</p></li></ul><p></p><h3>Kekurangan Produk (The Weaknesses)</h3><p></p><ul><li><p><strong>Variasi Rasa Terbatas (Limited Flavor Consistency):</strong> Karena kopi adalah produk pertanian, <strong>profil rasa dapat sedikit berfluktuasi</strong> antar musim panen (walaupun kami berusaha meminimalkannya).</p></li><li><p><strong>Membutuhkan Peralatan (Requires Equipment):</strong> Untuk mendapatkan rasa yang optimal, kopi ini <strong>membutuhkan alat seduh dan penggiling</strong> yang memadai. Jika diseduh tanpa pertimbangan air dan suhu yang tepat, potensi rasanya mungkin tidak tercapai maksimal.</p></li><li><p><strong>Sensitivitas Lambung (Stomach Sensitivity Risk):</strong> Bagi sebagian kecil konsumen dengan sensitivitas lambung, <strong>kandungan asam alami</strong> dalam kopi mungkin dapat memicu ketidaknyamanan jika dikonsumsi dalam keadaan perut kosong.</p></li></ul>',
                'price' => 15000.00
            ],
        ];

        foreach ($products as $product) {
            Product::create($product);
        }
    }
}
