<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Partnership;

class PartnershipSeeder extends Seeder
{
    public function run()
    {
        Partnership::truncate();

        $partnerships = [
            [
                'name' => 'BAPENA',
                'image_url' => '/partnership/BAPENA.png',
            ],
            [
                'name' => 'BPS',
                'image_url' => '/partnership/BPS.png',
            ],
            [
                'name' => 'Dinas Kesehatan',
                'image_url' => '/partnership/DINKES.png',
            ],
            [
                'name' => 'Klinik Komputer',
                'image_url' => '/partnership/KLINIK.png',
            ],
            [
                'name' => 'Universitas Mega Buana',
                'image_url' => '/partnership/MEGABUANA.png',
            ],
            [
                'name' => 'PPNI',
                'image_url' => '/partnership/PPNI.png',
            ],
            [
                'name' => 'Techno Kreatif Solusindo',
                'image_url' => '/partnership/TECHNO.png',
            ],
            [
                'name' => 'Masmindo',
                'image_url' => '/partnership/MASMINDO.png',
            ],
        ];

        foreach ($partnerships as $pt) {
            Partnership::create($pt);
        }
    }
}
