<?php

namespace Database\Seeders;

use App\Models\Article;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ArticleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Article::truncate();

        $articles = [
            [
                'title' => 'Magang Hub Memicu SDM Fresh Graduate Kota Palopo',
                'slug' => 'Magang-Hub-Memicu-SDM-Fresh-Graduate-Kota-Palopo',
                'description' => 'Program Magang Hub yang digagas oleh Kementerian Ketenagakerjaan Republik Indonesia
(Kemnaker) mulai menunjukkan dampak nyata di Kota Palopo. Sejumlah lulusan baru dari
berbagai perguruan tinggi kini tengah memulai babak baru dalam dunia kerja di sejumlah
perusahaan mitra, termasuk Digital Kreatif Agensi Palopo, perusahaan rintisan yang bergerak di
bidang layanan digital.

Program ini dirancang untuk menjembatani lulusan baru agar memperoleh pengalaman kerja riil
sebelum memasuki dunia profesional. Melalui Magang Hub, para peserta ditempatkan di
berbagai divisi strategis seperti content creator, desain grafis, Internet of Things (IoT), front-end,
back-end development, serta digital marketing.

“Magang ini menjadi titik awal bagi kami untuk berkembang. Kami belajar langsung bagaimana
ide diubah menjadi produk dan bagaimana tim bekerja di dunia nyata,” ujar Ibnu peserta magang
divisi Digital Marketing”, Jum’at 2025.',

                'image_url' => 'article/artikel_1.png',
                'seo_title' => 'Magang Hub Dorong SDM Fresh Graduate Palopo | DKA',
                'seo_description' => 'Program Magang Hub bantu fresh graduate Palopo kembangkan keterampilan profesional bersama Digital Kreatif Agensi untuk masa depan karier gemilang.'
            ],

            [
                'title' => 'BPS LUTRA Gelar Family Gathering, Digital Kreatif Agensi Kembali Dipercaya Jadi EO',
                'slug' => 'BPS-LUTRA-Gelar-Family-Gathering-Digital-Kreatif-Agensi-Kembali-Dipercaya-Jadi-EO',
                'description' => 'Badan Pusat Statistik (BPS) Kabupaten Luwu Utara kembali mempercayakan Digital Kreatif
Agensi (DKA) sebagai penyelenggara utama dalam kegiatan Family Gathering Instansi BPS,
yang akan digelar di Wasponda. Kepercayaan ini menjadi bukti kuat bahwa Digital Kreatif
Agensi, yang berbasis di Palopo, mampu bersaing secara profesional sebagai penyedia layanan
event kreatif.

Family Gathering ini akan diisi dengan beragam kegiatan, mulai dari games interaktif, sesi
sharing kreatif, hingga workshop ringan mengenai branding digital dan komunikasi publik.
Seluruh kegiatan dirancang agar peserta dapat membangun keakraban sambil berbagi wawasan

Dengan ditunjuknya Digital Kreatif Agensi sebagai EO resmi, acara ini diharapkan menjadi
contoh implementasi nyata sinergi antara lembaga pemerintah dan pelaku industri kreatif digital
dalam membangun citra daerah yang inovatif dan adaptif terhadap perkembangan zaman, Sabtu
2025.',
                'image_url' => 'article/artikel_2.png',
                'seo_title' => 'BPS Lutra Percaya Digital Kreatif Agensi Sebagai EO | DKA Palopo',
                'seo_description' => 'Digital Kreatif Agensi dipercaya kembali oleh BPS Luwu Utara sebagai event organizer Family Gathering, bukti profesionalisme EO Palopo yang inovatif dan kreatif.'
            ],

            [
                'title' => 'Klinik Komputer Siapkan Skillvara, Ruang Baru untuk Belajar Bahasa Inggris',
                'slug' => 'Klinik Komputer Siapkan Skillvara, Ruang Baru untuk Belajar Bahasa Inggris',
                'description' => 'Dari Komputer ke Komunikasi Global, klinik Komputer, lembaga pelatihan yang dikenal di Kota
Palopo melalui program kursus komputer dan teknologi, kembali berinovasi dengan
mempersiapkan Skillvara, anak cabang baru yang berfokus pada kursus Bahasa Inggris.

Langkah ini menjadi bagian dari komitmen Klinik Komputer dalam mendukung peningkatan
kompetensi masyarakat kota Palop, tidak hanya di bidang teknologi, tetapi juga dalam
kemampuan komunikasi global.

Selain Skillvara, Klinik Komputer sebelumnya telah mengembangkan dua unit usaha lainnya,
yaitu Techno yang bergerak di bidang layanan teknologi, serta Digital Kreatif yang berfokus
pada layanan promosi dan event digital.

Dengan peluncuran Skillvara, Klinik Komputer menegaskan perannya sebagai pelopor
pendidikan dan pengembangan keterampilan di Kota Palopo, Sabtu 2025.',
                'image_url' => 'article/artikel_3.png',
                'seo_title' => 'Skillvara: Kursus Bahasa Inggris dari Klinik Komputer Palopo',
                'seo_description' => 'Klinik Komputer Palopo meluncurkan Skillvara, ruang belajar Bahasa Inggris modern untuk mendukung kompetensi global masyarakat kota Palopo.'
            ],

            [
                'title' => '5 Tips Membuat Event yang Berkesan di Era Digital',
                'slug' => '5-Tips-Membuat-Event-yang-Berkesan-di-Era-Digital',
                'description' => 'Di era digital, sebuah event tak hanya soal panggung dan dekorasi, tapi juga bagaimana
menciptakan pengalaman yang menarik bagi peserta. Tim Digital Kreatif Ageni membagikan
lima tips utama untuk membuat acara lebih berkesan.

Mulailah dengan konsep yang unik dan relevan, manfaatkan media sosial untuk promosi, serta
tambahkan elemen interaktif agar audiens lebih terlibat. Kolaborasi dengan vendor profesional
dan evaluasi pascaacara juga penting untuk menjaga kualitas setiap event.

Dengan perencanaan yang matang dan kreativitas tanpa batas, setiap acara dapat menjadi
pengalaman yang menginspirasi dan meninggalkan kesan mendalam bagi peserta.

Digital Kreatif Agensi siap membantu Anda mewujudkan event yang sukses dan penuh makna,
Sabtu 2025.',
                'image_url' => 'article/artikel_4.png',
                'seo_title' => '5 Tips Event Berkesan di Era Digital | Digital Kreatif Agensi',
                'seo_description' => 'Pelajari 5 tips membuat event berkesan di era digital bersama Digital Kreatif Agensi Palopo. Tingkatkan pengalaman peserta dengan strategi kreatif dan efektif.'
            ]
        ];
        foreach ($articles as $article) {
            Article::create($article);
        }
    }
}
