<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class ProductImage extends Model
{
    use HasFactory;

    protected $fillable = [
        'product_id',
        'image_url',
        'caption',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

     protected static function booted()
    {
        static::deleting(function ($image) {
            if ($image->image_url) {
                Storage::disk('public')->delete($image->image_url);
            }
        });
    }
}
