<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'name',
        'main_image',
        'description',
        'price'
    ];

    public function images()
    {
        return $this->hasMany(ProductImage::class);
    }

    protected static function booted()
    {
        static::deleting(function ($product) {
            // hapus main image
            if ($product->main_image) {
                Storage::disk('public')->delete($product->main_image);
            }

            // hapus semua relasi images
            foreach ($product->images as $image) {
                $image->delete(); // ini akan memicu hook di ProductImage
            }
        });
    }

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($product) {
            // hapus main image
            if ($product->main_image) {
                Storage::disk('public')->delete($product->main_image);
            }

            // hapus semua relasi images
            foreach ($product->images as $image) {
                $image->delete(); // memicu boot pada ProductImage untuk hapus file-nya
            }
        });

        static::updated(function ($product) {
            // handle perubahan main image
            if ($product->wasChanged('main_image')) {
                $oldMain = $product->getOriginal('main_image');
                if ($oldMain) {
                    Storage::disk('public')->delete($oldMain);
                }
            }

            // handle perubahan relasi images
            $product->loadMissing('images');

            foreach ($product->images as $image) {
                if ($image->wasChanged('image_url')) {
                    $oldImage = $image->getOriginal('image_url');
                    if ($oldImage) {
                        Storage::disk('public')->delete($oldImage);
                    }
                }
            }
        });
    }
}
