<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Partnership extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'name',
        'image_url',
    ];

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($partnership) {
            if ($partnership->image_url) {
                Storage::disk('public')->delete($partnership->image_url);
            }
        });

        static::updating(function ($partnership) {
            if ($partnership->isDirty('image_url')) {
                Storage::disk('public')->delete($partnership->getOriginal('image_url'));
            }
        });
    }
}
