<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Article extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'slug',
        'description',
        'seo_title',
        'seo_description',
        'image_url',
    ];

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($article) {
            if ($article->image_url) {
                Storage::disk('public')->delete($article->image_url);
            }
        });

        static::updating(function ($article) {
            if ($article->isDirty('image_url')) {
                Storage::disk('public')->delete($article->getOriginal('image_url'));
            }
        });
    }
}
