<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Partnership;
use App\Models\Product;
use Illuminate\Http\Request;
use Inertia\Inertia;

class ProductController extends Controller
{
    public function index(Request $request)
    {
        $tumbler = Product::select('id', 'name', 'main_image')->where('name', 'Tumbler')->first();

        if ($tumbler) {
            $tumbler->main_image = asset('storage/' . $tumbler->main_image);
        }

        $query = $request->input('search');

        $products = Product::when($query, function ($q) use ($query) {
            $q->where('name', 'like', "%{$query}%");
        })
            ->select('id', 'name', 'main_image', 'price')->latest()
            ->paginate(6)
            ->through(fn($product) => [
                'id' => $product->id,
                'name' => $product->name,
                'price' => (int) $product->price,
                'main_image' => $product->main_image
                    ? asset('storage/' . $product->main_image)
                    : null,
            ]);

        $partnerships = Partnership::select('id', 'image_url')
            ->get()
            ->map(fn($p) => [
                'id' => $p->id,
                'image_url' => $p->image_url
                    ? asset('storage/' . ltrim($p->image_url, '/'))
                    : null,
            ]);

        return Inertia::render('products/all', [
            'products' => $products,
            'partnerships' => $partnerships,
            'tumbler' => $tumbler,
            'query' => $query
        ]);
    }


    // halaman detail produk
    public function detail(Request $request, $id)
    {
        $product = Product::with('images')
            ->select('id', 'name', 'description', 'main_image', 'price')
            ->findOrFail($id);

        $relatedProducts = Product::where('id', '!=', $id)
            ->select('id', 'name', 'main_image', 'price')
            ->latest()
            ->take(3)
            ->get()
            ->map(fn($p) => [ // Menggunakan map() karena hasilnya adalah Collection, bukan Paginator
                'id' => $p->id,
                'name' => $p->name,
                'price' => (int) $p->price,
                'main_image' => $p->main_image
                    ? asset('storage/' . ltrim($p->main_image, '/'))
                    : null,
            ]);

        $partnerships = Partnership::select('id', 'image_url')
            ->get()
            ->map(fn($p) => [
                'id' => $p->id,
                'image_url' => $p->image_url
                    ? asset('storage/' . ltrim($p->image_url, '/'))
                    : null,
            ]);

        return Inertia::render('products/detail', [
            'product' => [
                'id' => $product->id,
                'name' => $product->name,
                'description' => $product->description,
                'price' => (int) $product->price,
                'main_image' => $product->main_image
                    ? asset('storage/' . ltrim($product->main_image, '/'))
                    : null,
                'images' => $product->images->map(fn($img) => [
                    'id' => $img->id,
                    'image_url' => $img->image_url
                        ? asset('storage/' . ltrim($img->image_url, '/'))
                        : null,
                    'caption' => $img->caption,
                ]),
            ],
            'relatedProducts' => $relatedProducts,
            'partnerships' => $partnerships,
        ]);

        // return response()->json([
        //     'product' => [
        //         'id' => $product->id,
        //         'name' => $product->name,
        //         'description' => $product->description,
        //         'price' => (int) $product->price,
        //         'main_image' => $product->main_image
        //             ? asset('storage/' . ltrim($product->main_image, '/'))
        //             : null,
        //         'images' => $product->images->map(fn($img) => [
        //             'id' => $img->id,
        //             'image_url' => $img->image_url
        //                 ? asset('storage/' . ltrim($img->image_url, '/'))
        //                 : null,
        //             'caption' => $img->caption,
        //         ]),
        //     ],
        // ]);
    }
}
