<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Partnership;
use App\Models\Service;
use Illuminate\Http\Request;
use Inertia\Inertia;

class HomeController extends Controller
{
    public function index()
    {
        $partnerships = Partnership::select('id', 'image_url')
            ->get()
            ->map(fn($p) => [
                'id' => $p->id,
                'image_url' => $p->image_url
                    ? asset('storage/' . ltrim($p->image_url, '/'))
                    : null,
            ]);

        return Inertia::render('home', [
            'partnerships' => $partnerships
        ]);
    }
}
