<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Article;
use App\Models\Partnership;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Inertia\Inertia;

class ArticleController extends Controller
{
    public function index()
    {
        $articles = Article::select('id', 'title', 'slug', 'image_url', 'created_at')
            ->latest()
            ->take(4)
            ->get()
            ->map(fn($article) => [
                'id' => $article->id,
                'title' => $article->title,
                'slug' => $article->slug,
                'image_url' => $article->image_url ? asset('storage/' . $article->image_url) : null,
                'created_at' => $article->created_at,
            ]);

        $featuredArticle = $articles->shift();
        $sideArticles = $articles;

        $partnerships = Partnership::select('id', 'image_url')
            ->get()
            ->map(fn($p) => [
                'id' => $p->id,
                'image_url' => $p->image_url
                    ? asset('storage/' . ltrim($p->image_url, '/'))
                    : null,
            ]);

        return Inertia::render('articles/index', [
            'featuredArticle' => $featuredArticle,
            'sideArticles' => $sideArticles,
            'partnerships' => $partnerships
        ]);

        // return response()->json([
        //     'featuredArticle' => $featuredArticle,
        //     'sideArticles' => $sideArticles,
        //     'partnerships' => $partnerships,
        // ]);
    }

    // Halaman detail artikel
    public function detail($slug)
    {
        $detailArticle = Article::where('slug', $slug)->firstOrFail();

        $relatedArticles = Article::where('slug', '!=', $slug)
            ->select('id', 'title', 'slug', 'image_url', 'created_at')
            ->latest()
            ->take(3)
            ->get()
            ->map(fn($a) => [
                'id' => $a->id,
                'title' => $a->title,
                'slug' => $a->slug,
                'image_url' => $a->image_url ? asset('storage/' . $a->image_url) : null,
                'created_at' => $a->created_at->format('Y-m-d'),
            ]);

        $partnerships = Partnership::select('id', 'image_url')->get()
            ->map(fn($p) => [
                'id' => $p->id,
                'image_url' => $p->image_url ? asset('storage/' . ltrim($p->image_url, '/')) : null,
            ]);

        return Inertia::render('articles/detail', [
            'detailArticle' => [
                'id' => $detailArticle->id,
                'title' => $detailArticle->title,
                'description' => $detailArticle->description,
                'image_url' => $detailArticle->image_url ? asset('storage/' . $detailArticle->image_url) : null,
                'created_at' => $detailArticle->created_at->format('Y-m-d'),
            ],
            'relatedArticles' => $relatedArticles,
            'partnerships' => $partnerships,
        ]);

        // return response()->json([
        //     'detailArticle' => [
        //         'id' => $detailArticle->id,
        //         'title' => $detailArticle->title,
        //         'description' => $detailArticle->description,
        //         'image_url' => $detailArticle->image_url ? asset('storage/' . $detailArticle->image_url) : null,
        //         'created_at' => $detailArticle->created_at->format('Y-m-d'),
        //     ],
        //     'relatedArticles' => $relatedArticles,
        //     'partnerships' => $partnerships,
        // ]);
    }

    public function all(Request $request)
    {
        $query = $request->input('search');

        $articles = Article::when($query, function ($q) use ($query) {
            $q->where('title', 'like', "%{$query}%");
        })
            ->select('id', 'title', 'slug', 'description', 'image_url', 'created_at')
            ->latest()
            ->paginate(8)
            ->through(fn($article) => [
                'id' => $article->id,
                'title' => $article->title,
                'slug' => $article->slug,
                'description' => $article->description,
                'image_url' => $article->image_url ? asset('storage/' . $article->image_url) : null,
                'created_at' => $article->created_at->format('Y-m-d'),
            ]);

        $partnerships = Partnership::select('id', 'image_url')->get()
            ->map(fn($p) => [
                'id' => $p->id,
                'image_url' => $p->image_url ? asset('storage/' . ltrim($p->image_url, '/')) : null,
            ]);

        return Inertia::render('articles/all', [
            'articles' => $articles,
            'partnerships' => $partnerships,
            'query' => $query,
        ]);


        // return response()->json([
        //     'articlesAll' => $articlesAll,
        //     'partnerships' => $partnerships,
        // ]);
    }
}
