<?php

namespace App\Filament\Widgets;

use App\Filament\Resources\Articles\ArticleResource;
use App\Filament\Resources\Partnerships\PartnershipsResource;
use App\Filament\Resources\Products\ProductResource;
use App\Models\Article;
use App\Models\Partnership;
use App\Models\Product;
use Filament\Widgets\StatsOverviewWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class InfoOverview extends StatsOverviewWidget
{
    protected function getStats(): array
    {
        $totalArticles = Article::count();
        $totalProducts = Product::count();
        $totalPartnerships = Partnership::count(); 

        return [
            Stat::make('Total Artikel', $totalArticles)
                ->description('Artikel yang terpublikasi')
                ->descriptionIcon('heroicon-o-document-text')
                ->color('success')
                ->icon('heroicon-o-document-text')
                ->url(ArticleResource::getUrl('index')),

            Stat::make('Total Produk', $totalProducts)
                ->description('Produk yang terdaftar')
                ->descriptionIcon('heroicon-o-shopping-bag')
                ->color('primary')
                ->icon('heroicon-o-shopping-bag')
                ->url(ProductResource::getUrl('index')),

            Stat::make('Total Partner', $totalPartnerships)
                ->description('Partner yang bekerja sama')
                ->descriptionIcon('heroicon-o-hand-raised')
                ->color('info')
                ->icon('heroicon-o-briefcase')
                ->url(PartnershipsResource::getUrl('index')),
        ];
    }
}