<?php

namespace App\Filament\Resources\Products\Tables;

use App\Models\Product;
use Filament\Actions\Action;
use Filament\Actions\ActionGroup;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteAction;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class ProductsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('name')
                    ->label('Nama Product')
                    ->searchable()
                    ->sortable(),

                ImageColumn::make('main_image')
                    ->label('Gambar'),

                TextColumn::make('price')
                    ->label('Harga')
                    ->searchable()
                    ->sortable()
                    ->formatStateUsing(fn (int $state): string => 'Rp. ' . number_format($state, 0, ',', '.')),

                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])

            ->recordActions([
                ActionGroup::make([
                    DeleteAction::make(),
                    EditAction::make(),
                    Action::make('show')
                        ->label('Show Detail') // Label untuk tombol
                        ->icon('heroicon-o-eye') // Icon mata
                        ->url(fn(Product $record): string => route('products.detail', $record)) // Tentukan URL
                        // Pastikan route 'product.detail' sudah didefinisikan di web.php
                        ->openUrlInNewTab(), // Opsional: buka di tab baru
                ]),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
