<?php

namespace App\Filament\Resources\Products\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
use Illuminate\Support\Facades\Storage;

class ProductForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->schema([
            Grid::make()
                ->schema([
                    // Gunakan Grid nested agar layout lebih fleksibel
                    Grid::make(12)
                        ->schema([
                            // 🧩 Kolom kiri (Data Produk)
                            Section::make('Data Produk')
                                ->schema([
                                    TextInput::make('name')
                                        ->label('Nama Produk')
                                        ->required()
                                        ->maxLength(255),

                                    TextInput::make('price')
                                        ->label('Harga')
                                        ->required(),

                                    FileUpload::make('main_image')
                                        ->label('Gambar Utama')
                                        ->image()
                                        ->imageEditor()
                                        ->imagePreviewHeight('200')
                                        ->disk('public')
                                        ->visibility('public')
                                        ->directory('product')
                                        ->rules(['max:1024'])
                                        ->deleteUploadedFileUsing(fn($file) => Storage::disk('public')->delete($file))
                                        ->validationMessages([
                                            'max' => 'Besar sekali size gambar mu sdra maximal 1mb, kurangi dulu baru kembali ko lagi',
                                        ]),

                                    RichEditor::make('description')
                                        ->required()
                                        ->label('Deskripsi'),
                                ])
                                ->columnSpan(7), // kiri 7 dari 12 kolom

                            // 🎨 Kolom kanan (Gambar Tambahan)
                            Section::make('Gambar Tambahan')
                                ->schema([
                                    Repeater::make('images')
                                        ->label('Daftar Gambar')
                                        ->relationship('images')
                                        ->schema([
                                            FileUpload::make('image_url')
                                                ->label('Gambar')
                                                ->image()
                                                ->imageEditor()
                                                ->imagePreviewHeight('100')
                                                ->disk('public')
                                                ->visibility('public')
                                                ->directory('product/detail')
                                                ->rules(['max:1024'])
                                                ->deleteUploadedFileUsing(fn($file) => Storage::disk('public')->delete($file))
                                                ->validationMessages([
                                                    'max' => 'Besar sekali size gambar mu sdra maximal 1mb, kurangi dulu baru kembali ko lagi',
                                                ]),

                                            TextInput::make('caption')
                                                ->label('Warna')
                                                ->maxLength(255),
                                        ])
                                        ->collapsible()
                                        ->reorderable()
                                        ->defaultItems(0)
                                        ->addActionLabel('Tambah Gambar')
                                        // 🧱 Bagian penting: tambahkan tinggi & overflow scroll
                                        ->extraAttributes([
                                            'style' => 'max-height: 400px; overflow-y: auto; padding-right: 8px;',
                                        ]),
                                ])
                                ->columnSpan(5), // kanan 5 dari 12 kolom
                        ])
                        ->columns(12) // memastikan grid proporsional
                        ->columnSpanFull(),
                ])
                ->columnSpanFull(),
        ]);
    }
}
