<?php

namespace App\Filament\Resources\Partnerships\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
use Illuminate\Support\Facades\Storage;

class PartnershipsForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->schema([
            Section::make()->schema([
                TextInput::make('name')
                    ->label('Nama Instansi')
                    ->required()
                    ->rules([
                        'regex:/^[a-zA-Z\s]+$/',
                        'max:255',
                    ])
                    ->validationMessages([
                        'regex' => 'hanya boleh berisi huruf dan spasi.',
                    ]),

                FileUpload::make('image_url')
                    ->label('Logo Instansi')
                    ->required()
                    ->image()
                    ->imageEditor()
                    ->imagePreviewHeight('200')
                    ->disk('public')
                    ->visibility('public')
                    ->directory('partnership')
                    ->rules(['max:1024'])
                    ->deleteUploadedFileUsing(fn($file) => Storage::disk('public')->delete($file))
                    ->validationMessages([
                        'max' => 'Besar sekali size gambar mu sdra maximal 1mb, kurangi dulu baru kembali ko lagi',
                    ]),
            ])
        ]);
    }
}
