<?php

namespace App\Filament\Resources\Partnerships;

use App\Filament\Resources\Partnerships\Pages\CreatePartnerships;
use App\Filament\Resources\Partnerships\Pages\EditPartnerships;
use App\Filament\Resources\Partnerships\Pages\ListPartnerships;
use App\Filament\Resources\Partnerships\Schemas\PartnershipsForm;
use App\Filament\Resources\Partnerships\Tables\PartnershipsTable;
use App\Models\Partnership;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class PartnershipsResource extends Resource
{
    protected static ?string $model = Partnership::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    protected static ?string $recordTitleAttribute = 'name';

    public static function form(Schema $schema): Schema
    {
        return PartnershipsForm::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return PartnershipsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListPartnerships::route('/'),
            'create' => CreatePartnerships::route('/create'),
            'edit' => EditPartnerships::route('/{record}/edit'),
        ];
    }
}
