<?php

namespace App\Filament\Resources\Articles\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Components\Grid;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Schema;
use Illuminate\Support\Facades\Storage;

class ArticleForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema->schema([
            Grid::make()
                ->schema([
                    // Gunakan Grid nested agar layout lebih fleksibel
                    Grid::make(12)
                        ->schema([
                            // 🧩 Kolom kiri (Data Produk)
                            Section::make('')
                                ->schema([
                                    TextInput::make('title')
                                        ->required(),

                                    TextInput::make('slug')
                                        ->required(),

                                    TextInput::make('seo_title')
                                        ->required(),

                                    Textarea::make('seo_description')
                                        ->required(),

                                    FileUpload::make('image_url')
                                        ->label('Thumbnail')
                                        ->image()
                                        ->acceptedFileTypes(['image/png', 'image/jpg', 'image/jpeg', 'image/webp'])
                                        ->imageEditor()
                                        ->imagePreviewHeight('200')
                                        ->disk('public')
                                        ->visibility('public')
                                        ->directory('article')
                                        ->maxSize(1024)
                                        ->rules(['max:1024'])
                                        ->required()
                                        ->deleteUploadedFileUsing(fn($file) => Storage::disk('public')->delete($file))
                                        ->validationMessages([
                                            'max' => 'Besar sekali size gambar mu sdra maximal 1mb, kurangi dulu baru kembali ko lagi',
                                        ]),
                                ])
                                ->columnSpan(6), // kiri 7 dari 12 kolom

                            // 🎨 Kolom kanan (Gambar Tambahan)
                            Section::make('')
                                ->schema([
                                    RichEditor::make('description')
                                        ->required()
                                ])
                                ->columnSpan(6), // kanan 5 dari 12 kolom
                        ])
                        ->columns(12) // memastikan grid proporsional
                        ->columnSpanFull(),
                ])
                ->columnSpanFull(),
        ]);
    }
}
